<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */
    
    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "../../../classi/ecommerce/Prodotto.php";
    include "../../../gUtil/GestoreTabella.php";
    include "../../../classi/Tabella.php";
        
    if(isset($_GET["id"])) {
        $prodotto = $geecomDb->leggiSingolaRiga("geecEc_ordini",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $dataRegistrazione = date("d/m/Y",strtotime($prodotto["dataOrdine"]));
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Componente e-commerce - Creazione metodo spedizione</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                <form name="formProdotto" action="../../../controller/controllerElementi.php" method="post">
                    <input type="text" class="d-none" name="operazione" value="<?php echo((isset($prodotto) ? "modifica" : "crea")); ?>">
                    <input type="text" class="d-none" name="id" value="<?php echo((isset($prodotto) ? $prodotto["id"] : "0")); ?>">
                    
                    <div class="row py-4">
                        <?php 
                            if($status==300) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==370) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato nel nuovo portfolio
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        <input type="text" class="d-none" id="operazione" value="modifica">

                        <div class="col-12 ">
                            <div class="form-row mb-3">
                                <div class="col-md-7 d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="home.php">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">E-commerce</a></li>
                                            <li class="breadcrumb-item"><a href="index.php?status=230">Ordini</a></li>
                                            <li class="breadcrumb-item active" aria-current="page">Crea un nuovo ordine</li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-md-5 text-right">
                                    <a class="btn btn-primary mr-1" href="creaOrdine.php">Crea nuovo<i class="fas fa-plus ml-2"></i></a>
                                    <a class="btn btn-outline-primary" href="index.php?status=230"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>

                            
                                    <div class="row">
                                        <div class="col-lg-6 col-xl-5">
                                            <div class="card mb-4 box-shadow-lite">
                                                <div class="card-header">
                                                    <h5 class="mb-0"> Crea nuovo ordine</h5>
                                                </div>
                                                <div class="card-body">
                                                    <form action="">

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Data registrazione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <input type="date" class="form-control" name="dataRegistrazione" value="<?php echo date("Y-m-d") ?>">
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Ordinante</b></label>
                                                            <div class="col-sm-8">
                                                                <div class="d-flex">
                                                                    <select class="selectpicker" data-width="100%" data-live-search="true" name="idCliente">
                                                                        <option value="0">Nessuno</option>
                                                                        <?php
                                                                            $queryNomiTag = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente'";
                                                                            $risNomi      = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                            while($utente = $risNomi->fetch_assoc()) {
                                                                                echo"<option value=\"{$utente["id"]}\" >{$utente["nome"]} {$utente["cognome"]} - {$utente["organizzazione"]}</option>";
                                                                            }
                                                                        ?>
                                                                    </select>
                                                                    <button type="button" class="btn btn-primary ml-2">Carica</button>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Metodo pagamento</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <?php
                                                                    $metodiPagamento = array("paypal","stripe","bonifico","pagamento alla consegna");
                                                                ?>
                                                                <select class="selectpicker" data-width="100%" name="tipoPagamento">
                                                                    <?php
                                                                        foreach($metodiPagamento as $tipo) {
                                                                            echo"<option value=\"$tipo\" >{$tipo}</option>";
                                                                        }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Tipo di spedizione</b></label>
                                                            <div class="col-sm-8">
                                                                <select class="selectpicker" data-width="100%" data-live-search="true" name="idSpedizione">
                                                                    <?php
                                                                        $queryNomiTag  = "SELECT * FROM geecEc_metodiSpedizione ";
                                                                        $risSpedizioni = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                        while($spedizione = $risSpedizioni->fetch_assoc()) {
                                                                            echo"<option value=\"{$spedizione["id"]}\" >{$spedizione["nome"]}</option>";
                                                                        }
                                                                    ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Indirizzo di spedizione</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                                <input type="text" class="form-control" name="indirizzoSpedizione" value="" placeholder="Indirizzo spedizione">
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Email</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                              <input type="text" class="form-control" name="email" value="" placeholder="Email">
                                                            </div>
                                                        </div>

                                                        <div class="form-group row">
                                                            <label  class="col-sm-4 col-form-label"><b>Telefono</b></label>
                                                            <div class="col-sm-8 d-flex">
                                                              <input type="text" class="form-control" name="telefono" value="" placeholder="Telefono">
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                                <div class="card-footer">
                                                    <button type="button" class="btn btn-primary float-right btn-sm" onclick="aggiornaOrdine()"><i class="fas fa-check"></i> Salva</button>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div id="divElencoElementi" class="col-lg-6 col-xl-7">
                                            <div class="card mb-4 box-shadow-lite">
                                                <div class="card-body">
                                                    <div class="form-row mb-3">
                                                        <div class="col-sm-6 col-md-4 col-lg-6 col-xl-4 mb-2 mb-xl-0">
                                                            <select class="selectpicker" data-width="100%" data-live-search="true" name="idCliente">
                                                                <option value="0">Seleziona prodotto</option>
                                                                <?php
                                                                    $queryNomiTag = "SELECT * FROM geecEc_prodotti";
                                                                    $risNomi      = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                    while($prodotto = $risNomi->fetch_assoc()) {
                                                                        echo"<option value=\"{$prodotto["id"]}\" >{$prodotto["nome"]}</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <div class="col-sm-6 col-md-4 col-lg-6 col-xl-4 mb-2 mb-xl-0">
                                                            <select class="selectpicker" data-width="100%" name="idCliente">
                                                                <option value="0">Seleziona variazione</option>
                                                                <?php
                                                                    $queryNomiTag = "SELECT * FROM geecEc_prodotti";
                                                                    $risNomi      = $geecomDb->eseguiQueryLettura($queryNomiTag);
                                                                    while($prodotto = $risNomi->fetch_assoc()) {
                                                                        echo"<option value=\"{$prodotto["id"]}\" >{$prodotto["nome"]}</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <div class="col-sm-6 col-md-2 col-lg-6 col-xl-2 mb-2 mb-xl-0">
                                                            <input type="number" class="form-control" name="dataRegistrazione" value="<?php echo date("Y-m-d") ?>" placeholder="Quantità">
                                                        </div>
                                                        
                                                        <div class="col-auto">
                                                            <button type="button" class="btn btn-primary"><i class="fas fa-plus mr-2"></i>Aggiungi</button>
                                                        </div>
                                                    </div>
                                                    <?php
                                                        $colonne = array("Oggetto","Quantità","Costo unitario");
                                                        $tabella = new Tabella("tabella", "table table-striped table-hover",$colonne);
                                                        $tabella->setTipo("normale");
                                                        
                                                        $tabella->stampa();
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                        </div>
                        
                        <!-- Colonna principale -->
                </div>

            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
        ?>
            <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Eliminare l'immagine?</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="d-flex flex-row justify-content-center">
                                <img id="percorsoImmagineDaEliminare" class="img-fluid" src="">
                            </div>
                            <input type="text" class="d-none" id="idImmagineDaEliminare">
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneOccorrenzaImmagine('../../../')"><i class="fas fa-check"></i> Elimina</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php
            include "../include/jsBaseComponenti.php";
        ?>
    </body>
</html>